function CT_RAMeters_Out(...)
	local tmp = "";
	for i = 1, arg.n, 1 do
		if ( strlen(tmp) > 0 ) then
			tmp = tmp .. " ";
		end
		tmp = tmp .. "|c00FF0000#|r " .. arg[i];
	end
	CT_Print(tmp .. " |c00FF0000#|r");
end

function CT_RAMeters_RecordHeal()
	if ( event == "CHAT_MSG_SPELl_SELF_BUFF" ) then
		local _, _, spell, target, amount = string.find(arg1, "^Your (.+) critically heals (.+) for (%d+)%.$");
		if ( spell ) then
			CT_RAMeters_AddSelfHeal(spell, tonumber(amount), target, 1);
			return;
		end
		_, _, spell, target, amount = string.find(arg1, "^Your (.+) heals (.+) for (%d+)%.$");
		if ( spell ) then
			CT_RAMeters_AddSelfHeal(spell, tonumber(amount), target);
			return;
		end
	end
end

function CT_RAMeters_AddSelfHeal(spellName, healAmount, targetName)
	if ( not CT_RAMeters_CurrHealth[targetName] ) then
		return;
	end
	CT_RAMeters_CurrHealth[targetName][2] = { UnitName("player"), spellName, healAmount };
end

function CT_RAMeters_RecordHealth()
	local name, newHealth = UnitName(arg1), UnitHealth(arg1);
	if ( CT_RAMeters_CurrHealth[name] and CT_RAMeters_CurrHealth[name][2] and newHealth > CT_RAMeters_CurrHealth[name][1] ) then
		-- Update healing stats
		local caster, spellName, healAmount = CT_RAMeters_CurrHealth[name][2][1], CT_RAMeters_CurrHealth[name][2][2], CT_RAMeters_CurrHealth[name][2][3], ( newHealth - CT_RAMeters_CurrHealth[name] );
		if ( not CT_RAMeters_Stats[caster] ) then
			CT_RAMeters_InitiateTable(caster);
		end
		CT_RAMeters_Stats[caster]["Healing"]["Total"] = CT_RAMeters_Stats[caster]["Healing"]["Total"] + healAmount;
		if ( not CT_RAMeters_Stats[caster]["Healing"][spellName] ) then
			CT_RAMeters_Stats[caster]["Healing"][spellName] = healAmount;
		else
			CT_RAMeters_Stats[caster]["Healing"][spellName] = CT_RAMeters_Stats[caster]["Healing"][spellName] + healAmount;
		end
	end
	CT_RAMeters_CurrHealth[name] = { newHealth };
end

function CT_RAMeters_InitiateTable(key)
	CT_RAMeters_Stats[key] = {
		["Healing"] = {
			["Total"] = 0
		},
		["Damage"] = {
			["Total"] = 0
		}
	};
end

function CT_RAMeters_OnLoad()
--~ 	for k, v in CT_RAMeters_Events do
--~ 		this:RegisterEvent(k);
--~ 	end
end

function CT_RAMeters_OnEvent(event)
	if ( CT_RAMeters_Events[event] and type(CT_RAMeters_Events[event]) == "function" ) then
		CT_RAMeters_Events[event]();
	end
end

-- Global variables

CT_RAMeters_Events = {
	["CHAT_MSG_SPELL_SELF_BUFF"] = CT_RAMeters_RecordHeal,
	["CHAT_MSG_SPELL_PARTY_BUFF"] = CT_RAMeters_RecordHeal,
	["CHAT_MSG_SPELL_FRIENDLYPLAYER_BUFF"] = CT_RAMeters_RecordHeal,
	["UNIT_HEALTH"] = CT_RAMeters_RecordHealth
};

CT_RAMeters_CurrHealth = { };
CT_RAMeters_Stats = { };